/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.extender;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.utils.extender.Extension;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class SimpleExtension
implements Extension {
    private final Bundle bundle;
    private final BundleContext bundleContext;
    private final AtomicBoolean destroyed = new AtomicBoolean(false);

    public SimpleExtension(Bundle bundle) {
        this.bundle = bundle;
        this.bundleContext = bundle.getBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        Object object = this.getLock();
        synchronized (object) {
            return this.destroyed.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this.getLock();
        synchronized (object) {
            if (this.destroyed.get()) {
                return;
            }
            if (this.bundle.getState() != 32) {
                return;
            }
            if (this.bundle.getBundleContext() != this.bundleContext) {
                return;
            }
            this.doStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        Object object = this.getLock();
        synchronized (object) {
            this.destroyed.set(true);
        }
        this.doDestroy();
    }

    protected Object getLock() {
        return this;
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doDestroy() throws Exception;
}

