-- Script SQL PostgreSQL pour la base de données manage_peoples_db
-- Création de la base de données (si elle n'existe pas)

-- DROP DATABASE IF EXISTS manage_peoples_db;
-- CREATE DATABASE manage_peoples_db;

-- Connexion à la base de données
-- \c manage_peoples_db;

-- Suppression de la table si elle existe (optionnel)
DROP TABLE IF EXISTS person CASCADE;

-- Création de la table person
CREATE TABLE person (
    id SERIAL PRIMARY KEY,
    first_name VARCHAR(50),
    last_name VARCHAR(50),
    weight DOUBLE PRECISION,
    size DOUBLE PRECISION,
    street VARCHAR(100),
    postal_code VARCHAR(10),
    city VARCHAR(50),
    country VARCHAR(50),
    version INTEGER DEFAULT 0
);

-- Insertion de 10 personnes
INSERT INTO person (first_name, last_name, weight, size, street, postal_code, city, country, version) VALUES
('Jean', 'Dupont', 75.5, 1.75, '12 Rue de la Paix', '75001', 'Paris', 'France', 0),
('Marie', 'Martin', 62.3, 1.65, '34 Avenue des Champs', '69001', 'Lyon', 'France', 0),
('Pierre', 'Durand', 82.0, 1.82, '56 Boulevard Victor Hugo', '31000', 'Toulouse', 'France', 0),
('Sophie', 'Bernard', 58.7, 1.68, '78 Rue Nationale', '59000', 'Lille', 'France', 0),
('Luc', 'Petit', 90.2, 1.88, '90 Cours Mirabeau', '13100', 'Aix-en-Provence', 'France', 0),
('Julie', 'Moreau', 65.4, 1.70, '23 Quai de la Fosse', '44000', 'Nantes', 'France', 0),
('Marc', 'Simon', 78.9, 1.77, '45 Place Bellecour', '69002', 'Lyon', 'France', 0),
('Céline', 'Laurent', 55.2, 1.62, '67 Rue du Commerce', '75015', 'Paris', 'France', 0),
('Thomas', 'Lefebvre', 85.6, 1.85, '89 Avenue de la République', '33000', 'Bordeaux', 'France', 0),
('Isabelle', 'Roux', 60.1, 1.66, '12 Place du Capitole', '31000', 'Toulouse', 'France', 0);

-- Vérification des données insérées
SELECT * FROM person ORDER BY id;

-- Statistiques
SELECT COUNT(*) as total_persons FROM person;
SELECT city, COUNT(*) as count FROM person GROUP BY city ORDER BY count DESC;
SELECT country, COUNT(*) as count FROM person GROUP BY country;
