package com.training.controller;

import com.training.entities.Person;

/**
 * Mapper pour convertir entre Person (entité) et PersonApi (DTO)
 */
public class PersonMapper {

    /**
     * Convertit une entité Person en DTO PersonApi
     */
    public static PersonApi toApi(Person person) {
        if (person == null) {
            return null;
        }

        return PersonApi.builder()
                .id(person.getId())
                .firstName(person.getFirstName())
                .lastName(person.getLastName())
                .weight(person.getWeight())
                .size(person.getSize())
                .street(person.getStreet())
                .postalCode(person.getPostalCode())
                .city(person.getCity())
                .country(person.getCountry())
                .version(person.getVersion())
                .build();
    }

    /**
     * Convertit un DTO PersonApi en entité Person
     */
    public static Person toEntity(PersonApi personApi) {
        if (personApi == null) {
            return null;
        }

        return Person.builder()
                .id(personApi.getId())
                .firstName(personApi.getFirstName())
                .lastName(personApi.getLastName())
                .weight(personApi.getWeight())
                .size(personApi.getSize())
                .street(personApi.getStreet())
                .postalCode(personApi.getPostalCode())
                .city(personApi.getCity())
                .country(personApi.getCountry())
                .version(personApi.getVersion())
                .build();
    }
}
