package com.cours.entities;

import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlRootElement;

import com.cours.utils.Constants;

/**
 *
 * @author ElHadji
 */
@Entity
@Table(name = "Personne")
@XmlRootElement
@NamedQueries({
        @NamedQuery(name = "Personne.findAll", query = "SELECT person FROM Personne person"),
        @NamedQuery(name = "Personne.findByIdPersonne", query = "SELECT person FROM Personne person WHERE person.idPersonne = :idPersonne")})
public class Personne implements Serializable, Comparable<Personne> {

    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Basic(optional = false)
    @Column(name = "idPersonne")
    private Integer idPersonne;
    @Column(name = "prenom")
    private String prenom;
    @Column(name = "nom")
    private String nom;
    @Column(name = "poids")
    private Double poids;
    @Column(name = "taille")
    private Double taille;
    @Column(name = "rue")
    private String rue;
    @Column(name = "codePostal")
    private String codePostal;
    @Column(name = "ville")
    private String ville;
    @Column(name = "pays")
    private String pays;
    @Column(name = "version")
    @Version
    private Integer version;

    public Personne() {

    }

    public Personne(String prenom, String nom, Double poids, Double taille, String rue, String ville, String codePostal,
            String pays) {
        this.prenom = prenom;
        this.nom = nom;
        this.poids = poids;
        this.taille = taille;
        this.rue = rue;
        this.codePostal = codePostal;
        this.ville = ville;
        this.pays = pays;
    }

    public Personne(Integer idPersonne, String prenom, String nom, Double poids, Double taille, String rue,
            String ville, String codePostal, String pays) {
        this.idPersonne = idPersonne;
        this.prenom = prenom;
        this.nom = nom;
        this.poids = poids;
        this.taille = taille;
        this.rue = rue;
        this.codePostal = codePostal;
        this.ville = ville;
        this.pays = pays;
    }

    public Integer getIdPersonne() {
        return idPersonne;
    }

    public void setIdPersonne(Integer idPersonne) {
        this.idPersonne = idPersonne;
    }

    public String getNom() {
        return nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public Double getPoids() {
        return poids;
    }

    public void setPoids(Double poids) {
        this.poids = poids;
    }

    public Double getTaille() {
        return taille;
    }

    public void setTaille(Double taille) {
        this.taille = taille;
    }

    public String getPrenom() {
        return prenom;
    }

    public void setPrenom(String prenom) {
        this.prenom = prenom;
    }

    public String getRue() {
        return rue;
    }

    public void setRue(String rue) {
        this.rue = rue;
    }

    public String getVille() {
        return ville;
    }

    public void setVille(String ville) {
        this.ville = ville;
    }

    public String getCodePostal() {
        return codePostal;
    }

    public void setCodePostal(String codePostal) {
        this.codePostal = codePostal;
    }

    public String getPays() {
        return pays;
    }

    public void setPays(String pays) {
        this.pays = pays;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return String.format(
                "[idPersonne=%s, prenom=%s, nom=%s, poids=%s, taille=%s, rue=%s,  ville=%s, codePostal=%s, pays=%s]",
                idPersonne, prenom, nom, poids, taille, rue, ville, codePostal, pays);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = result * prime + this.prenom.hashCode();
        result = result * prime + this.nom.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Personne)) {
            return false;
        }
        Personne otherPerson = (Personne) obj;
        return (otherPerson.getPrenom().equals(getPrenom()) && otherPerson.getNom().equals(getNom()));
    }

    @Override
    public int compareTo(Personne otherPerson) {
        return (this.getPrenom() + this.getNom()).compareTo(otherPerson.getPrenom() + otherPerson.getNom());
    }

    public double getImc() {
        double imc = 0;
        if (taille != 0) {
            imc = poids / Math.pow(taille / 100, 2);
        }
        return imc;
    }

    public boolean isMaigre() {
        double imc = getImc();
        return imc > Constants.LIMITE_INF_MAIGRE && imc < Constants.LIMITE_SUP_MAIGRE;
    }

    public boolean isSurPoids() {
        double imc = getImc();
        return imc > Constants.LIMITE_INF_SURPOIDS && imc < Constants.LIMITE_SUP_SURPOIDS;
    }

    public boolean isObese() {
        double imc = getImc();
        return imc > Constants.LIMITE_SUP_SURPOIDS;
    }
}
