package com.cours.controller;

import com.cours.entities.Personne;
import com.cours.service.IPersonneService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.server.ResponseStatusException;

import java.util.List;

@RestController
@RequestMapping( "/api" )
public class PersonneController
{
    private static final Log log = LogFactory.getLog( PersonneController.class );
    @Autowired
    private IPersonneService personneService;

    @GetMapping
    public ResponseEntity<List<Personne>> findAll( )
    {
        return new ResponseEntity<List<Personne>>( personneService.findAll( ), HttpStatus.OK );
    }

    @GetMapping( "/{id}" )
    public Personne findById( @PathVariable Integer id )
    {
        return personneService.findById( id )
                .orElseThrow( ( ) -> new ResponseStatusException( HttpStatus.NOT_FOUND, "La Personne id = " + id + " est introuvable." ) );
    }

    @GetMapping( "/findByPrenom" )
    public ResponseEntity<List<Personne>> findByPrenom( @RequestParam String prenom )
    {
        List<Personne> personnes = personneService.findByPrenom( prenom );
        log.debug( "personnes : " + personnes );
        return new ResponseEntity<List<Personne>>( personnes, HttpStatus.OK );
    }

    @GetMapping( "/findByNom" )
    public ResponseEntity<List<Personne>> findByNom( @RequestParam String nom )
    {
        List<Personne> personnes = personneService.findByNom( nom );
        log.debug( "personnes : " + personnes );
        return new ResponseEntity<List<Personne>>( personnes, HttpStatus.OK );
    }

    @GetMapping( "/authenticate" )
    public ResponseEntity<List<Personne>> authenticate( @RequestParam String prenom, @RequestParam String nom )
    {
        List<Personne> personnes = personneService.findByPrenomNom( prenom, nom );
        log.debug( "personnes : " + personnes );
        return new ResponseEntity<List<Personne>>( personnes, HttpStatus.OK );
    }

    @DeleteMapping( "/{id}" )
    public ResponseEntity<String> delete( @PathVariable Integer id )
    {
        try
        {
            Personne person = personneService.findById( id )
                    .orElseThrow( ( ) -> new ResponseStatusException( HttpStatus.NOT_FOUND, "La Personne id = " + id + " est introuvable." ) );
            personneService.delete( person );
        }
        catch( Exception e )
        {
            log.error( "e : " + e );
            throw new ResponseStatusException( HttpStatus.NOT_FOUND,
                    "La suppression de la Personne id = " + id + " a déclanché un erreur, Exception : " + e.getMessage( ) );
        }
        return ResponseEntity.ok( "La suppression de la Personne id = " + id + " a reussi" );
    }

    @PostMapping
    public ResponseEntity<Personne> create( @RequestBody Personne person )
    {
        ResponseEntity<Personne> responseEntity = null;
        log.debug( "Param person : " + person );
        try
        {
            person = personneService.createOrUpdate( person );
            log.debug( "Created person : " + person );
            responseEntity = new ResponseEntity<Personne>( person, HttpStatus.CREATED );
        }
        catch( Exception e )
        {
            log.error( "e : " + e );
            throw new ResponseStatusException( HttpStatus.NO_CONTENT, "La créationde la Personne person = " + person + " a déclanché une erreur." );
        }
        return responseEntity;
    }

    @PutMapping
    public ResponseEntity<Personne> update( @RequestBody Personne person )
    {
        ResponseEntity<Personne> responseEntity = null;
        Integer idPersonne = person.getIdPersonne( );
        log.debug( "Param person : " + person );
        try
        {
            person = personneService.findById( idPersonne )
                    .orElseThrow( ( ) -> new ResponseStatusException( HttpStatus.NOT_FOUND, "La Personne id = " + idPersonne + " est introuvable." ) );
            person = personneService.createOrUpdate( person );
            log.debug( "Created person : " + person );
            responseEntity = new ResponseEntity<Personne>( person, HttpStatus.CREATED );
        }
        catch( Exception e )
        {
            log.error( "e : " + e );
            throw new ResponseStatusException( HttpStatus.NO_CONTENT, "La créationde la Personne person = " + person + " a déclanché une erreur." );
        }
        return responseEntity;
    }
}
