package com.cours.controller;

import com.cours.entities.MyEntity;
import com.cours.repository.MyEntityRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

import java.util.List;

@RestController
@RequestMapping( "/api" )
public class MyEntityController
{

    @Autowired
    private MyEntityRepository myEntityRepository;

    @GetMapping
    public List<MyEntity> findAll( )
    {
        return myEntityRepository.findAll( );
    }

    @GetMapping( "findById/{id}" )
    public MyEntity findById( @PathVariable Integer id )
    {
        return myEntityRepository.findById( id )
                .orElseThrow( ( ) -> new ResponseStatusException( HttpStatus.NOT_FOUND, "Le MyEntity id = " + id + " est introuvable." ) );
    }

    @GetMapping( "findByField1/{field1}" )
    public List<MyEntity> findByField1( @PathVariable String field1 )
    {
        List<MyEntity> myEntities = myEntityRepository.findByField1( field1 );
        if ( myEntities == null )
        {
            throw new ResponseStatusException( HttpStatus.NOT_FOUND, "Aucun MyEntity avec field1 = " + field1 + " n'a été trouvé." );
        }
        return myEntities;
    }

    @GetMapping( "findByField2/{field2}" )
    public List<MyEntity> findByField2( @PathVariable String field2 )
    {
        List<MyEntity> myEntities = myEntityRepository.findByField1( field2 );
        if ( myEntities == null )
        {
            throw new ResponseStatusException( HttpStatus.NOT_FOUND, "Aucun MyEntity avec field2 = " + field2 + " n'a été trouvé." );
        }
        return myEntities;
    }
}
